------------------------------------------------------------------------
-- Event:        Delphi Day 2018, Piacenza, June 06 2018               -
--               https://www.delphiday.it/                             -
-- Seminary:     How to write high performance queries in T-SQL        -
-- Demo:         Execution Plan - Extra operators                      -
-- Author:       Sergio Govoni                                         -
-- Notes:        --                                                    -
------------------------------------------------------------------------

USE [AdventureWorks2017];
GO


------------------------------------------------------------------------
-- Extra Operators                                                     -
------------------------------------------------------------------------

-- Operatori che non ci aspettiamo di trovare
-- nel piano di esecuzione
SET STATISTICS TIME ON;
SET STATISTICS IO ON;

DBCC FREEPROCCACHE;

-- #1
EXEC dbo.usp_StateProvinceByTerritory N'Australia';
GO


-- #2 
SELECT
  *
FROM
  Sales.SalesOrderHeader AS h
JOIN
  Sales.SalesOrderDetail AS d
  ON h.SalesOrderID=d.SalesOrderID
WHERE
  d.ProductID = 31;
GO